/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xapp;

import java.util.Enumeration;
import java.util.Vector;

public final class Option {
    private static Vector<Option> options = new Vector();
    private String name;
    private String description;
    private String parameter;
    private boolean present;
    private String value = null;

    public Option(String name, String description, String parameter) {
        this.name = name;
        this.description = description;
        this.parameter = parameter;
        options.addElement(this);
    }

    public Option(String name, String description) {
        this(name, description, null);
    }

    public final boolean isPresent() {
        return this.present;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.toDebug() + "]";
    }

    public static String[] processOptions(String[] arguments) {
        int index = 0;
        while (index < arguments.length) {
            Enumeration<Option> cursor = options.elements();
            boolean matched = false;
            while (cursor.hasMoreElements()) {
                Option option = cursor.nextElement();
                matched = arguments[index].equals(option.name);
                if (!matched) continue;
                option.present = true;
                if (option.parameter == null) break;
                option.value = arguments[++index];
                break;
            }
            if (!matched) break;
            ++index;
        }
        String[] remainder = new String[arguments.length - index];
        int count = 0;
        while (index < arguments.length) {
            remainder[count++] = arguments[index++];
        }
        return remainder;
    }

    public static String listOptions() {
        StringBuffer buffer = new StringBuffer();
        Enumeration<Option> cursor = options.elements();
        while (cursor.hasMoreElements()) {
            Option option = cursor.nextElement();
            if (buffer.length() == 0) {
                buffer.append(' ');
            }
            buffer.append('[');
            buffer.append(option.name);
            if (option.parameter != null) {
                buffer.append(' ');
                buffer.append(option.parameter);
            }
            buffer.append(']');
        }
        return buffer.toString();
    }

    public static void describeOptions() {
        String spaces = "                                            ";
        Enumeration<Option> cursor = options.elements();
        while (cursor.hasMoreElements()) {
            Option option = cursor.nextElement();
            if (option.parameter != null) {
                System.err.println("    " + (String.valueOf(option.name) + " " + option.parameter + spaces).substring(0, 16) + " " + option.description);
                continue;
            }
            System.err.println("    " + (String.valueOf(option.name) + spaces).substring(0, 16) + " " + option.description);
        }
    }

    protected String toDebug() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("name=" + (this.name != null ? this.name : "null"));
        buffer.append(",description=" + (this.description != null ? this.description : "null"));
        buffer.append(",parameter=" + (this.parameter != null ? this.parameter : "null"));
        buffer.append(",present=" + this.present);
        return buffer.toString();
    }
}

